<?php
include 'db.php';
include 'koneksi.php';
include 'session_check.php'; // Untuk keamanan session

if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $koneksi->query("DELETE FROM mata_kuliah WHERE id='$id'");
    header("Location: mata_kuliah.php");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Kelola Mata Kuliah</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

  <div class="flex">
    <!-- Sidebar -->
    <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
      <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
      <nav class="space-y-1">
        <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
        <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
        <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700 bg-blue-700">📘 Kelola Mata Kuliah</a>
        <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
        <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
        <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
        <hr class="my-3 border-gray-700">
        <a href="users.php" class="block py-2 px-4 rounded hover:bg-blue-700">👥 Manajemen User</a>
        <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
      </nav>
    </div>

    <!-- Main Content -->
    <div class="flex-1 p-8">
      <h2 class="text-3xl font-semibold mb-6">Kelola Mata Kuliah</h2>
      <a href="tambah_mata_kuliah.php" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded inline-block mb-4">+ Tambah Mata Kuliah</a>

      <div class="overflow-x-auto">
        <table class="min-w-full bg-white border border-gray-300 rounded-lg shadow">
          <thead class="bg-blue-600 text-white">
            <tr>
              <th class="py-2 px-4 border">No</th>
              <th class="py-2 px-4 border">Nama MK</th>
              <th class="py-2 px-4 border">Kode MK</th>
              <th class="py-2 px-4 border">SKS</th>
              <th class="py-2 px-4 border">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $no = 1;
            $query = $koneksi->query("SELECT * FROM mata_kuliah");
            while ($data = $query->fetch_assoc()) {
              echo "<tr class='text-center hover:bg-gray-100'>
                      <td class='py-2 px-4 border'>{$no}</td>
                      <td class='py-2 px-4 border'>{$data['nama_mk']}</td>
                      <td class='py-2 px-4 border'>{$data['kode_mk']}</td>
                      <td class='py-2 px-4 border'>{$data['sks']}</td>
                      <td class='py-2 px-4 border'>
                        <a href='edit_mata_kuliah.php?id={$data['id']}' class='text-yellow-500 hover:underline'>Edit</a> |
                        <a href='?hapus={$data['id']}' onclick=\"return confirm('Yakin hapus?')\" class='text-red-500 hover:underline'>Hapus</a>
                      </td>
                    </tr>";
              $no++;
            }
            ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</body>
</html>
